% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vdi.R
\name{vdi}
\alias{vdi}
\title{vdi}
\usage{
vdi(dc, dmc)
}
\arguments{
\item{dc}{is the Raster* containing the Drought Code.}

\item{dmc}{is the Raster* containing the Duff Moisture Code.}
}
\value{
The function returns a categorical Raster* object.
Values and their descriptions are listed below:
\enumerate{
\item 1 = No fire vulnerability, corresponding to an important superficial
humidification.
\item 2 = Very limited drying. Small fires possible.
\item 3 = The zone is considered vulnerable, due to strong wind and low humidity.
\item 4 = Important drying; the zone is considered vulnerable. Fires can occur in
any conditions, excepts by high air moisture. Very severe Fire Weather
Danger by moderate wind, even low wind with foehn effect or very hot and
very dry air. Strong drougth rules are applied, the FWI is no longer
appropriate.
\item 5 = Extreme drying, the zone is considered extremely vulnerable. Very big
fire conditions are gathered. Permanent risk of very big fires on slope
zones. Catastrophic fires are possible in any zones, by moderate or strong
wind. Strong drought rules are applied, the FWI is no longer appropriate.
The IPse works well and models very fast fire propagation speeds (sometimes
underestimated).
}

The function returns a categorical Raster* object with extent,
resolution and land-sea mask matching those of \code{dc} (or \code{dmc}).
Values are integers in the range [1, 5].
}
\description{
This function calculates the Vegetation Drought Index
(defined by Meteo France), as a combination of Drought Code and Duff Moisture
Code
}
\examples{
\dontrun{
  dc <- brick("dc.nc")
  dmc <- brick("dmc.nc")
  x <- vdi(dc, dmc)
}

}
