% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{wrap}
\alias{wrap}
\title{Wrap Characters in Parentheses}
\usage{
wrap(x)
}
\arguments{
\item{x}{\code{character}.}
}
\value{
\code{character}.
}
\description{
Wraps \code{characters} in round brackets.
}
\details{
Characters are automatically wrapped when performing basic symbolic operations to prevent unwanted results. E.g.: 
\deqn{a+b * c+d} 
instead of 
\deqn{(a+b) * (c+d)}
To disable this behaviour run \code{options(calculus.auto.wrap = FALSE)}.
}
\examples{
### wrap characters
wrap("a+b")

### wrap array of characters
wrap(array(letters[1:9], dim = c(3,3)))

}
\references{
Guidotti, E. (2020). "calculus: High dimensional numerical and symbolic calculus in R". \url{https://arxiv.org/abs/2101.00086}
}
\seealso{
Other utilities: 
\code{\link{c2e}()},
\code{\link{e2c}()},
\code{\link{evaluate}()}
}
\concept{utilities}
