% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cusecovar.R
\name{Cusecovar}
\alias{Cusecovar}
\title{Cusecovar}
\usage{
Cusecovar(xref, amplif, n)
}
\arguments{
\item{xref}{: matrix [ . , NPar ] of the reference population whose covariance structure is to be used}

\item{amplif}{: amplification factor of the standard deviation on each parameter}

\item{n}{: number of new vectors to generate}
}
\value{
xnew : matrix [ n , NPar ] of new vectors
}
\description{
proposes new parameter vectors respecting a covariance structure
}
\examples{
# Definition of the parameters
xref <- matrix(rexp(35), 35, 1)
amplif <- 2.
n <- 5
# Call the function
res <- Cusecovar(xref, amplif, n)

}
\author{
Fabrice Zaoui
}
