% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{calculateModelSelectionCriteria}
\alias{calculateModelSelectionCriteria}
\title{Model selection criteria}
\usage{
calculateModelSelectionCriteria(
  .object          = NULL,
  .ms_criterion    = c("all", "aic", "aicc", "aicu", "bic", "fpe", "gm", "hq",
                       "hqc", "mallows_cp"),
  .by_equation     = TRUE, 
  .only_structural = TRUE 
  )
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.ms_criterion}{Character string. Either a single character string or a vector
of character strings naming the model selection criterion to compute.
Defaults to \code{"all"}.}

\item{.by_equation}{Should the criteria be computed for each structural model
equation separately? Defaults to \code{TRUE}.}

\item{.only_structural}{Should the the log-likelihood be based on the
structural model? Ignored if \code{.by_equation == TRUE}. Defaults to \code{TRUE}.}
}
\value{
If \code{.by_equation == TRUE} a named list of model selection criteria.
}
\description{
Calculate several information or model selection criteria (MSC) such as the
Akaike information criterion (AIC), the Bayesian information criterion (BIC) or
the Hannan-Quinn criterion (HQ).
}
\details{
By default, all criteria are calculated (\code{.ms_criterion == "all"}). To compute only
a subset of the criteria a vector of criteria may be given.

If \code{.by_equation == TRUE} (the default), the criteria are computed for each
structural equation of the model separately, as suggested by
\insertCite{Sharma2019;textual}{cSEM} in the context of PLS. The relevant formula can be found in
Table B1 of the appendix of \insertCite{Sharma2019;textual}{cSEM}.

If \code{.by_equation == FALSE} the AIC, the BIC and the HQ for whole model
are calculated. All other criteria are currently ignored in this case!
The relevant formulae are (see, e.g., \insertCite{Akaike1974}{cSEM},
\insertCite{Schwarz1978;textual}{cSEM},
\insertCite{Hannan1979;textual}{cSEM}):

\deqn{AIC = - 2*log(L) + 2*k}
\deqn{BIC = - 2*log(L) + k*ln(n)}
\deqn{HQ  = - 2*log(L) + 2*k*ln(ln(n))}

where log(L) is the log likelihood function of the multivariate normal
distribution of the observable variables, k the (total) number of estimated parameters,
and n the sample size.

If \code{.only_structural == TRUE}, log(L) is based on the structural model only.
The argument is ignored if \code{.by_equation == TRUE}.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=assess]{assess()}}, \link{cSEMResults}
}
