% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{elfe}
\alias{elfe}
\title{Sentence completion test from ELFE 1-6}
\format{
A data frame with 1400 rows and 3 variables:
\describe{
  \item{personID}{ID of the student}
  \item{group}{grade level, with x.5 indicating the end of the school year and x.0 indicating the middle of the school year}
  \item{raw}{the raw score of the student, spanning values from 0 to 28}
}

A data frame with 1400 rows and 3 columns
}
\source{
\url{https://www.psychometrica.de/elfe2.html}
}
\usage{
elfe
}
\description{
A dataset containing the raw data of 1400 students from grade 2 to 5 in the sentence
comprehension test from ELFE 1-6 (Lenhard & Schneider, 2006). In this test, students
are presented lists of sentences with one gap. The student has to fill in the correct
solution by selecting from a list of 5 alternatives per sentence. The alternatives
include verbs, adjectives, nouns, pronouns and conjunctives. Each item stems from
the same word type. The text is speeded, with a time cutoff of 180 seconds. The
variables are as follows:
}
\examples{
# prepare data, retrieve model and plot percentiles
data.elfe <- prepareData(elfe)
model.elfe <- bestModel(data.elfe)
plotPercentiles(data.elfe, model.elfe)
}
\references{
Lenhard, W. & Schneider, W.(2006). Ein Leseverstaendnistest fuer Erst- bis Sechstklaesser. Goettingen/Germany: Hogrefe.
}
\concept{reading comprehension}
\keyword{datasets}
