% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-forecast.R
\name{relmae}
\alias{relmae}
\alias{relmae.predbvhar}
\alias{relmae.bvharcv}
\title{Evaluate the Model Based on RelMAE (Relative MAE)}
\usage{
relmae(x, pred_bench, y, ...)

\method{relmae}{predbvhar}(x, pred_bench, y, ...)

\method{relmae}{bvharcv}(x, pred_bench, y, ...)
}
\arguments{
\item{x}{Forecasting object to use}

\item{pred_bench}{The same forecasting object from benchmark model}

\item{y}{Test data to be compared. should be the same format with the train data.}

\item{...}{not used}
}
\value{
RelMAE vector corresponding to each variable.
}
\description{
This function computes RelMAE given prediction result versus evaluation set.
}
\details{
Let \eqn{e_t = y_t - \hat{y}_t}.
RelMAE implements MAE of benchmark model as relative measures.
Let \eqn{MAE_b} be the MAE of the benchmark model.
Then

\deqn{RelMAE = \frac{MAE}{MAE_b}}

where \eqn{MAE} is the MAE of our model.
}
\references{
Hyndman, R. J., & Koehler, A. B. (2006). \emph{Another look at measures of forecast accuracy}. International Journal of Forecasting, 22(4), 679–688.
}
