% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_fhx}
\alias{read_fhx}
\title{Read FHX2 file and return an `fhx`` object}
\usage{
read_fhx(fname, encoding, text)
}
\arguments{
\item{fname}{Name of target FHX file. Needs to be in format version 2.}

\item{encoding}{Encoding to use when reading the FHX file. The default is to
use the system default in R.}

\item{text}{Character string. If \code{fname} is not provided and text is, then
data is read from text using a text connection.}
}
\value{
An \code{fhx} object, as returned by \code{\link[=fhx]{fhx()}}.
}
\description{
Read FHX2 file and return an `fhx`` object
}
\examples{
\dontrun{
d <- read_fhx("afile.fhx")
}

}
\seealso{
\itemize{
\item \code{\link[=write_fhx]{write_fhx()}} write an \code{fhx} object to a file.
\item \code{\link[=fhx]{fhx()}} create an \code{fhx} object.
\item \code{\link[=as_fhx]{as_fhx()}} cast data frame or similar object to an \code{fhx} object.
}
}
