% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer_square.R
\name{buffer_square}
\alias{buffer_square}
\title{A square Function}
\usage{
buffer_square(point, length, degree = 0)
}
\arguments{
\item{point}{Centre point of the buffer, must equal to true in: \code{sf::st_is(point, "POINT")}}

\item{length}{Length of the square sides, should be in the unit of projection (numeric)}

\item{degree}{The angle at which the square  is centred (clockwise). Must be between 0 and 360 (numeric)}
}
\value{
An object of class \code{sfc_POLYGON}
}
\description{
Creates a square polygon, wrapper around \code{buffer_rectangle(point, x_length = length, y_length = length, degree)}
}
\examples{
example_point = sf::st_point(c(1,2))
example_point = sf::st_sfc(example_point)
example_point = sf::st_sf(example_point)
buffer_square(example_point, 90, 22) -> square_shaped_buffer
plot(square_shaped_buffer)
}
\keyword{square}
