% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrangeFunctions.R
\name{combinePanels}
\alias{combinePanels}
\title{Combine Multiple Panels In A New gTree.}
\usage{
combinePanels(
  name,
  panels,
  nrow,
  ncol,
  spacer = unit(0, "cm"),
  margin = unit(0, "cm"),
  just = c(0.5, 0.5)
)
}
\arguments{
\item{name}{Character string naming the new tree and viewport (viewport will
have suffix "VP")}

\item{panels}{Panels to be arranged in the new tree}

\item{nrow}{Numeric, number of rows in the new layout}

\item{ncol}{Numeric, number of columns in the new layout}

\item{spacer}{Grid \code{\link[grid]{unit}} object specifying size of space
left between panels.}

\item{margin}{Grid \code{\link[grid]{unit}} object specifying size of margin
around tree.}

\item{just}{Numeric or character vector specifying justification of panel
viewports within new tree viewport layout cells.
See \code{\link[grid]{viewport}}.}
}
\value{
New \code{\link[grid]{gTree}} object with children slot containing
all trees in the grobLists of input panels, and a childrenvp slot containing
all viewports in input panels arranged within a new parent viewport layout.
}
\description{
The combinePanels function creates a new gTree containing a viewport with a
grid layout, and arranges multiple panels (created with the
\code{\link{arrangePanels}} function) within that grid. The new layout is
filled by rows.
}
