% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.R
\name{forecast.PosteriorBSVARSV}
\alias{forecast.PosteriorBSVARSV}
\title{Forecasting using Structural Vector Autoregression}
\usage{
\method{forecast}{PosteriorBSVARSV}(posterior, horizon)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
PosteriorBSVARSV obtained by running the \code{estimate} function.}

\item{horizon}{a positive integer, specifying the forecasting horizon.}
}
\value{
A list of class \code{Forecasts} containing the
draws from the predictive density and for heteroskedastic models the draws from the predictive density of 
structural shocks conditional standard deviations. The output elements include:

\describe{
 \item{forecasts}{an \code{NxTxS} array with the draws from predictive density}
 \item{forecasts_sigma}{provided only for heteroskedastic models, an \code{NxTxS} array with the draws 
 from the predictive density of structural shocks conditional standard deviations}
}
}
\description{
Samples from the joint predictive density of all of the dependent variables at forecast horizons 
from 1 to \code{horizon} specified as an argument of the function.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar_sv$new(us_fiscal_lsuw, p = 1)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 10, thin = 2)

# sample from predictive density 1 year ahead
predictive     = forecast(posterior, 4)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_sv$new(p = 1) |>
  estimate(S = 10) |>
  estimate(S = 10, thin = 2) |>  
  forecast(horizon = 4) -> predictive
  
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
