% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{compute_conditional_sd.PosteriorBSVARSIGN}
\alias{compute_conditional_sd.PosteriorBSVARSIGN}
\title{Computes posterior draws of structural shock conditional standard deviations}
\usage{
\method{compute_conditional_sd}{PosteriorBSVARSIGN}(posterior)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
\code{PosteriorBSVARSIGN} obtained by running the \code{estimate} function.}
}
\value{
An object of class \code{PosteriorSigma}, that is, an \code{NxTxS} 
array with attribute \code{PosteriorSigma} containing \code{S} draws of the 
structural shock conditional standard deviations.
}
\description{
Each of the draws from the posterior estimation of models is 
transformed into a draw from the posterior distribution of the structural 
shock conditional standard deviations.
}
\examples{
# upload data
data(optimism)

# specify the model and set seed
set.seed(123)

# + no effect on productivity (zero restriction)
# + positive effect on stock prices (positive sign restriction) 
sign_irf       = matrix(c(0, 1, rep(NA, 23)), 5, 5)
specification  = specify_bsvarSIGN$new(optimism, sign_irf = sign_irf)

# estimate the model
posterior      = estimate(specification, 10)

# compute structural shocks' conditional standard deviations
sigma          = compute_conditional_sd(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
optimism |>
  specify_bsvarSIGN$new(sign_irf = sign_irf) |> 
  estimate(S = 10) |> 
  compute_conditional_sd() -> csd

}
\seealso{
\code{\link{estimate.BSVARSIGN}}
}
\author{
Xiaolei Wang \email{adamwang15@gmail.com} and Tomasz Woźniak \email{wozniak.tom@pm.me}
}
