% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_gibbs_core.R
\name{dbspline}
\alias{dbspline}
\title{Generate a cubic B-spline density basis}
\usage{
dbspline(x, knots)
}
\arguments{
\item{x}{numeric vector for which the B-spline densities are to be generated}

\item{knots}{knots used to generate the cubic B-spline densities}
}
\value{
matrix of the cubic B-spline density basis
}
\description{
This function generates a cubic B-spline density basis.
}
\details{
\link{splineDesign} is used to generate a cubic B-spline basis.  Each B-spline is then normalised to become a B-spline density using analytical integration.  Note that the two end knots are each coincident four times.
}
\examples{
\dontrun{

# Generate basis functions
x = seq(0, 1, length = 256)
knots = sort(c(0, runif(10), 1))
basis = dbspline(x, knots)

# Plot basis functions
plot(x, basis[1, ], type = "l", ylim = c(min(basis), max(basis)))
for (i in 2:nrow(basis)) lines(x, basis[i, ], col = i)
}
}
\seealso{
\link{splineDesign}
}
