% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_blocks.R
\name{bs_get_blocks}
\alias{bs_get_blocks}
\title{Retrieve user (self) blocks}
\usage{
bs_get_blocks(
  limit = NULL,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{limit}{Integer. Maximum number to request. Maximum: \code{100}}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of blocked accounts
}
\description{
Retrieve user (self) blocks
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/getBlocks.json}{graph/getBlocks.json (2023-10-02)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-02)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_get_blocks()
\dontshow{\}) # examplesIf}
}
\concept{graph}
