% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrayplot.R
\name{arrayplot}
\alias{arrayplot}
\title{Array Plotting}
\usage{
arrayplot(
  y,
  mini = -max(abs(min(y)), max(y)),
  maxi = max(abs(min(y)), max(y)),
  colors = 1,
  ylab = "",
  xlab = "",
  main = ""
)
}
\arguments{
\item{y}{a numerical data.frame or matrix object}

\item{mini, }{minimum color range (might cause blank spots if misspecified)}

\item{maxi, }{maximum color range (might cause blank spots if misspecified)}

\item{colors}{1 = blue/red, 0 = white/black}

\item{ylab}{y axis label passed to \code{lattice::levelplot}  function}

\item{xlab}{x axis label passed to \code{lattice::levelplot} function}

\item{main}{plot title passed to \code{lattice::levelplot} function}
}
\description{
Graphical representation for matrix class objects using lattice package
}
\examples{
dt <- simdata()

arrayplot(dt$real$alpha)
arrayplot(dt$real$alpha, colors = 0)

}
\seealso{
\code{\link[bsem]{simdata}}, \code{\link[bsem]{summary.bsem}}, \code{\link[bsem]{plot.bsem}}, \code{\link[bsem]{sem}}, \code{\link[bsem]{runShiny}}
}
\author{
VD Mayrink
}
