% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_04_regress.R
\name{model_summary}
\alias{model_summary}
\title{Tidy report of regression models.}
\usage{
model_summary(
  model.list,
  std = FALSE,
  digits = 3,
  nsmall = digits,
  file = NULL,
  zero = ifelse(std, FALSE, TRUE),
  modify.se = NULL,
  modify.head = NULL,
  line = TRUE,
  bold = 0,
  ...
)
}
\arguments{
\item{model.list}{A single model or a list of (various types of) models.
Most types of regression models are supported!}

\item{std}{Standardized coefficients? Default is \code{FALSE}.
Only applicable to linear models and linear mixed models.
Not applicable to generalized linear (mixed) models.}

\item{digits, nsmall}{Number of decimal places of output. Default is \code{3}.}

\item{file}{File name of MS Word (\code{.doc}).}

\item{zero}{Display "0" before "."? Default is \code{TRUE}.}

\item{modify.se}{Replace standard errors.
Useful if you need to replace raw SEs with robust SEs.
New SEs should be provided as a list of numeric vectors.
See usage in \code{\link[texreg:screenreg]{texreg::screenreg()}}.}

\item{modify.head}{Replace model names.}

\item{line}{Lines look like true line (\code{TRUE}) or \code{=== --- ===} (\code{FALSE}).
Only relevant to R Console output.}

\item{bold}{The \emph{p}-value threshold below which the coefficients will be formatted in bold.}

\item{...}{Other arguments passed to
\code{\link[texreg:screenreg]{texreg::screenreg()}} or
\code{\link[texreg:htmlreg]{texreg::htmlreg()}}.}
}
\value{
Invisibly return the output (character string).
}
\description{
Tidy report of regression models (most model types are supported).
This function uses:
\itemize{
  \item \code{\link[texreg:screenreg]{texreg::screenreg()}}
  \item \code{\link[texreg:htmlreg]{texreg::htmlreg()}}
  \item \code{\link[MuMIn:std.coef]{MuMIn::std.coef()}}
  \item \code{\link[MuMIn:r.squaredGLMM]{MuMIn::r.squaredGLMM()}}
  \item \code{\link[performance:r2_mcfadden]{performance::r2_mcfadden()}}
  \item \code{\link[performance:r2_nagelkerke]{performance::r2_nagelkerke()}}
}
}
\examples{
\dontrun{

  #### Example 1: Linear Model ####
  lm1=lm(Temp ~ Month + Day, data=airquality)
  lm2=lm(Temp ~ Month + Day + Wind + Solar.R, data=airquality)
  model_summary(lm1)
  model_summary(lm2)
  model_summary(list(lm1, lm2))
  model_summary(list(lm1, lm2), std=TRUE, digits=2)
  model_summary(list(lm1, lm2), file="OLS Models.doc")
  unlink("OLS Models.doc")  # delete file for code check

  #### Example 2: Generalized Linear Model ####
  glm1=glm(case ~ age + parity,
           data=infert, family=binomial)
  glm2=glm(case ~ age + parity + education + spontaneous + induced,
           data=infert, family=binomial)
  model_summary(list(glm1, glm2))  # "std" is not applicable to glm
  model_summary(list(glm1, glm2), file="GLM Models.doc")
  unlink("GLM Models.doc")  # delete file for code check

  #### Example 3: Linear Mixed Model ####
  library(lmerTest)
  hlm1=lmer(Reaction ~ (1 | Subject), data=sleepstudy)
  hlm2=lmer(Reaction ~ Days + (1 | Subject), data=sleepstudy)
  hlm3=lmer(Reaction ~ Days + (Days | Subject), data=sleepstudy)
  model_summary(list(hlm1, hlm2, hlm3))
  model_summary(list(hlm1, hlm2, hlm3), std=TRUE)
  model_summary(list(hlm1, hlm2, hlm3), file="HLM Models.doc")
  unlink("HLM Models.doc")  # delete file for code check

  #### Example 4: Generalized Linear Mixed Model ####
  library(lmerTest)
  data.glmm=MASS::bacteria
  glmm1=glmer(y ~ trt + week + (1 | ID), data=data.glmm, family=binomial)
  glmm2=glmer(y ~ trt + week + hilo + (1 | ID), data=data.glmm, family=binomial)
  model_summary(list(glmm1, glmm2))  # "std" is not applicable to glmm
  model_summary(list(glmm1, glmm2), file="GLMM Models.doc")
  unlink("GLMM Models.doc")  # delete file for code check

  #### Example 5: Multinomial Logistic Model ####
  library(nnet)
  d=airquality
  d$Month=as.factor(d$Month)  # Factor levels: 5, 6, 7, 8, 9
  mn1=multinom(Month ~ Temp, data=d, Hess=TRUE)
  mn2=multinom(Month ~ Temp + Wind + Ozone, data=d, Hess=TRUE)
  model_summary(mn1)
  model_summary(mn2)
  model_summary(mn2, file="Multinomial Logistic Model.doc")
  unlink("Multinomial Logistic Model.doc")  # delete file for code check
}

}
\seealso{
\code{\link{print_table}} (print simple table)

\code{\link{GLM_summary}}

\code{\link{HLM_summary}}

\code{\link{med_summary}}

\code{\link{lavaan_summary}}

\code{\link{PROCESS}}
}
