% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bingroup-tidiers.R
\name{glance.binDesign}
\alias{glance.binDesign}
\title{Glance at a(n) binDesign object}
\usage{
\method{glance}{binDesign}(x, ...)
}
\arguments{
\item{x}{A \link[binGroup:binDesign]{binGroup::binDesign} object.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modeling
function. This includes the name of the modeling function or any
arguments passed to the modeling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.

Glance returns the same number of columns regardless of whether the
model matrix is rank-deficient or not. If so, entries in columns
that no longer have a well-defined value are filled in with an \code{NA}
of the appropriate type.
}
\examples{
\dontshow{if (rlang::is_installed("binGroup")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# load libraries for models and data
library(binGroup)

des <- binDesign(
  nmax = 300, delta = 0.06,
  p.hyp = 0.1, power = .8
)

glance(des)
tidy(des)

library(ggplot2)

ggplot(tidy(des), aes(n, power)) +
  geom_line()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[binGroup:binDesign]{binGroup::binDesign()}}

Other bingroup tidiers: 
\code{\link{tidy.binDesign}()},
\code{\link{tidy.binWidth}()}
}
\concept{bingroup tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with exactly one row and columns:
  \item{power}{Power achieved by the analysis.}
  \item{n}{Sample size used to achieve this power.}
  \item{power.reached}{Whether the desired power was reached.}
  \item{maxit}{Number of iterations performed.}

}
