% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speedlm_tidiers.R
\name{speedlm_tidiers}
\alias{speedlm_tidiers}
\alias{tidy.speedlm}
\alias{glance.speedlm}
\alias{augment.speedlm}
\title{Tidying methods for a speedlm model}
\usage{
\method{tidy}{speedlm}(x, conf.int = FALSE, conf.level = 0.95,
  exponentiate = FALSE, quick = FALSE, ...)

\method{glance}{speedlm}(x, ...)

\method{augment}{speedlm}(x, data = stats::model.frame(x), newdata = data,
  ...)
}
\arguments{
\item{x}{speedlm object}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level of the interval, used only if
\code{conf.int=TRUE}}

\item{exponentiate}{whether to exponentiate the coefficient estimates
and confidence intervals (typical for logistic regression)}

\item{quick}{whether to compute a smaller and faster version, containing
only the \code{term} and \code{estimate} columns.}

\item{...}{extra arguments (not used)}

\item{data}{data frame to augment}

\item{newdata}{new data to use for predictions, optional}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy.speedlm} returns the tidied output of the
lm with one row for each term in the formula.
The columns match those in \link{lm_tidiers}.

\code{glance.speedlm} returns a one-row data.frame with the columns
  \item{r.squared}{The percent of variance explained by the model}
  \item{adj.r.squared}{r.squared adjusted based on the degrees of freedom}
  \item{statistic}{F-statistic}
  \item{p.value}{p-value from the F test, describing whether the full
  regression is significant}
  \item{df}{Degrees of freedom used by the coefficients}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{deviance}
  \item{df.residual}{residual degrees of freedom}

\code{augment.speedlm} returns  one row for each observation, with just one column added:
  \item{.fitted}{Fitted values of model}
}
\description{
These methods tidy the coefficients of a "speedlm" object 
into a summary, augment the original data with information on the
fitted values and residuals, and construct a one-row glance of the model's
statistics.
}
\examples{

if (require("speedglm", quietly = TRUE)) {
    mod <- speedglm::speedlm(mpg ~ wt + qsec, data = mtcars)
    tidy(mod)
    glance(mod)
    augment(mod)
}

}
\seealso{
\link{lm_tidiers}, \link{biglm_tidiers}
}
