% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_and_attach.R
\name{tidy_attach_model}
\alias{tidy_attach_model}
\alias{tidy_and_attach}
\alias{tidy_get_model}
\alias{tidy_detach_model}
\title{Attach a full model to the tibble of model terms}
\usage{
tidy_attach_model(x, model, .attributes = NULL)

tidy_and_attach(model, tidy_fun = broom::tidy, exponentiate = FALSE, ...)

tidy_get_model(x)

tidy_detach_model(x)
}
\arguments{
\item{x}{a tibble of model terms}

\item{model}{a model to be attached/tidied}

\item{.attributes}{named list of additional attributes to be attached to \code{x}}

\item{tidy_fun}{option to specify a custom tidier function}

\item{exponentiate}{logical indicating whether or not to exponentiate the
coefficient estimates. This is typical for logistic, Poisson and Cox models,
but a bad idea if there is no log or logit link; defaults to \code{FALSE}}

\item{...}{other arguments passed to \code{tidy_fun()}}
}
\description{
To facilitate the use of broom helpers with pipe, it is recommended to
attach the original model as an attribute to the tibble of model terms
generated by \code{broom::tidy()}.
}
\details{
\code{tidy_attach_model()} attach the model to a tibble already generated while
\code{tidy_and_attach()} will apply \code{broom::tidy()} and attach the model.

Use \code{tidy_get_model()} to get the model attached to the tibble and
\code{tidy_detach_model()} to remove the attribute containing the model.
}
\examples{
mod <- lm(Sepal.Length ~ Sepal.Width + Species, data = iris)
tt <- mod \%>\%
  tidy_and_attach(conf.int = TRUE)
tt
tidy_get_model(tt)
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_remove_intercept}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
