% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runningmean.R
\name{runningratio}
\alias{runningratio}
\title{Running ratio}
\usage{
runningratio(pos, numerator, denominator, at = NULL, window = 1000)
}
\arguments{
\item{pos}{Positions for the values.}

\item{numerator}{Values for numerator in ratio.}

\item{denominator}{Values for denominator in ratio.}

\item{at}{Positions at which running ratio is
calculated.  If NULL, \code{pos} is used.}

\item{window}{Window width.}
}
\value{
A vector with the same length as the input \code{at} (or \code{pos},
if \code{at} is NULL), containing the running ratio.
}
\description{
Calculates a running ratio; a ratio sum(top)/sum(bottom) in a sliding window.
}
\examples{
x <- 1:1000
y <- runif(1000, 1, 5)
z <- runif(1000, 1, 5)
plot(x, runningratio(x, y, z, window=5), type="l", lwd=2)
lines(x, runningratio(x, y, z, window=50), lwd=2, col="blue")
lines(x, runningratio(x, y, z, window=100), lwd=2, col="red")

}
\seealso{
\code{\link[=runningmean]{runningmean()}}
}
\author{
Karl W Broman \email{broman@wisc.edu}
}
\keyword{univar}
