% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rowBootMeans}
\alias{rowBootMeans}
\title{Bootstrap Row Means}
\usage{
rowBootMeans(x)
}
\arguments{
\item{x}{A numeric matrix}
}
\value{
A numeric vector with the simple bootstrapped row means of the matrix
}
\description{
This takes a numeric matrix, bootstrap resamples each row, and then
calculates the mean. The intended use case is for Bayesian posterior
predictions from sample data. Instead of directly calculating the
average marginal effect (AME) across all observed values, these can be
bootstrapped, so that uncertainty in the target population, and thus
the AME in the target population, can be incorporated.
Model uncertainty is already assumed to be handled by the different posterior
samples, which are assumed to be across rows.
}
\examples{

x <- matrix(1:9, byrow = TRUE, 3)
replicate(10, rowBootMeans(x))
}
