% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R,
%   R/misc-methods.R
\name{posterior_summary.brmsfit}
\alias{posterior_summary.brmsfit}
\alias{posterior_summary}
\alias{posterior_summary.default}
\title{Summarize Posterior Samples}
\usage{
\method{posterior_summary}{brmsfit}(x, pars = NA, probs = c(0.025, 0.975),
  robust = FALSE, ...)

posterior_summary(x, ...)

\method{posterior_summary}{default}(x, probs = c(0.025, 0.975),
  robust = FALSE, ...)
}
\arguments{
\item{x}{An \R object.}

\item{pars}{Names of parameters for which posterior samples 
should be returned, as given by a character vector or regular expressions.
By default, all posterior samples of all parameters are extracted.}

\item{probs}{The percentiles to be computed by the 
\code{quantile} function.}

\item{robust}{If \code{FALSE} (the default) the mean is used as 
the measure of central tendency and the standard deviation as 
the measure of variability. If \code{TRUE}, the median and the 
median absolute deviation (MAD) are applied instead.}

\item{...}{More arguments passed to or from other methods.}
}
\value{
A matrix where rows indicate parameters 
 and columns indicate the summary estimates.
}
\description{
Summarizes posterior samples based on point estimates (mean or median),
estimation errors (SD or MAD) and quantiles.
}
\examples{
\dontrun{
fit <- brm(time ~ age * sex, data = kidney)
posterior_summary(fit)
}

}
