% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{update.brmsfit}
\alias{update.brmsfit}
\title{Update \pkg{brms} models}
\usage{
\method{update}{brmsfit}(object, formula., newdata = NULL, ...)
}
\arguments{
\item{object}{object of class \code{brmsfit}}

\item{formula.}{changes to the formula; for details see 
\code{\link[stats:update.formula]{update.formula}}}

\item{newdata}{optional \code{data.frame} 
to update the model with new data}

\item{...}{other arguments passed to 
\code{\link[brms:brm]{brm}}}
}
\description{
This method allows to update an existing \code{brmsfit} object
}
\details{
Sometimes, when updating the model formula, 
 it may happen that \R complains about a mismatch
 between \code{model frame} and \code{formula}.
 This error can be avoided by supplying your orginal data
 again via argument \code{newdata}.
}
\examples{
\dontrun{
fit1 <- brm(time | cens(censored) ~ age * sex + disease + (1|patient), 
            data = kidney, family = gaussian("log"))
summary(fit1)

## remove effects of 'disease'
fit2 <- update(fit1, formula. = ~ . - disease)
summary(fit2)

## remove the group specific term of 'patient' and
## change the data (just take a subset in this example)
fit3 <- update(fit1, formula. = ~ . - (1|patient), 
               newdata = kidney[1:38, ])
summary(fit3)

## use another family and add fixed effects priors
fit4 <- update(fit1, family = weibull(), inits = "0",
               prior = set_prior("normal(0,5)"))
summary(fit4)
}

}

