% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{pp_check.brmsfit}
\alias{pp_check}
\alias{pp_check.brmsfit}
\title{Posterior Predictive Checks for \code{brmsfit} Objects}
\usage{
\method{pp_check}{brmsfit}(object, type, nsamples, group = NULL, x = NULL,
  newdata = NULL, re_formula = NULL, allow_new_levels = FALSE,
  incl_autocor = TRUE, subset = NULL, ntrys = 5, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{type}{Type of the ppc plot as given by a character string.
Currently, the following plots (as names) are implemented:
\code{dens} \code{dens_overlay}, \code{ecdf_overlay}, 
\code{error_binned}, \code{error_hist}, \code{error_scatter}, 
\code{error_scatter_avg}, \code{error_scatter_avg_vs_x},
\code{freqpoly}, \code{freqpoly_grouped}, \code{hist},
\code{intervals}, \code{intervals_grouped}, 
\code{ribbon}, \code{ribbon_grouped}, \code{scatter},
\code{scatter_avg}, \code{scatter_avg_grouped}, 
\code{stat}, \code{stat_2d}, \code{stat_freqpoly_grouped},
\code{stat_grouped}, and \code{violin_grouped}.}

\item{nsamples}{Positive integer indicating how many
posterior samples should be used.
If \code{NULL} all samples are used. If not specified,
the number of posterior samples is chosen automatically.
Ignored if \code{subset} is not \code{NULL}.}

\item{group}{Optional name of a grouping factor in the model
by which to stratify the ppc plot. This argument is required for
ppc \code{*_grouped} types and ignored otherwise.}

\item{x}{Optional name of a variable in the model. 
Only used for ppc types having an \code{x} argument 
and ignored otherwise.}

\item{newdata}{An optional data.frame for which to evaluate predictions.
If \code{NULL} (default), the orginal data of the model is used.}

\item{re_formula}{formula containing random effects 
to be considered in the prediction. 
If \code{NULL} (default), include all random effects; 
if \code{NA}, include no random effects.}

\item{allow_new_levels}{A flag indicating if new
levels of random effects are allowed (defaults to \code{FALSE}). 
Only relevant if \code{newdata} is provided.}

\item{incl_autocor}{A flag indicating if autocorrelation
parameters should be included in the predictions. 
Defaults to \code{TRUE}.}

\item{subset}{A numeric vector specifying
the posterior samples to be used. 
If \code{NULL} (the default), all samples are used.}

\item{ntrys}{Parameter used in rejection sampling
for truncated discrete models only
(defaults to \code{5}). For more details see
\code{\link[brms:predict.brmsfit]{predict.brmsfit}}.}

\item{...}{Further arguments passed to the ppc functions
of the \pkg{\link[bayesplot:bayesplot]{bayesplot}} package.}
}
\value{
A ggplot object that can be further
 customized using the \pkg{ggplot2} package.
}
\description{
Perform posterior predictive checks with the help
of the \pkg{bayesplot} package.
}
\details{
For a detailed explanation of each of the ppc functions, 
see the \code{\link[bayesplot:PPC-overview]{PPC}} 
documentation of the \pkg{\link[bayesplot:bayesplot]{bayesplot}} 
package.
}
\examples{
\dontrun{
fit <-  brm(count ~ log_Age_c + log_Base4_c * Trt_c
            + (1|patient) + (1|visit),
            data = epilepsy, family = poisson())

pp_check(fit)  # shows dens_overlay plot by default
pp_check(fit, type = "error_hist", nsamples = 11)
pp_check(fit, type = "scatter_avg", nsamples = 100)
pp_check(fit, type = "stat_2d")
}
}

