% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breathtest_read_function.R
\name{breathtest_read_function}
\alias{breathtest_read_function}
\title{Snoop method to read breath test file}
\usage{
breathtest_read_function(filename = NULL, text = NULL)
}
\arguments{
\item{filename}{breath test data file from Iris/Wagner (extended or CSV), 
BreathID}

\item{text}{as alternative to filename, pass the text of the file directly.
This parameter is not used for Excel files.}
}
\value{
Function to read the file or the text; NULL if no matching function 
was found
}
\description{
Reads the first line of a file, and returns
the best matching function to read the breath test data in it.
To automatically read the file with the inferred file type,
use \code{\link{read_any_breathtest}}. For Excel files, only the
first sheet is read.
}
\examples{
 file = btcore_file("IrisCSV.TXT")
 # Get function to read this file. Returns \\code{\\link{read_iris_csv}}.
 read_fun = breathtest_read_function(file)
 str(read_fun(file))
 # or, simple (returns a list!)
 str(read_any_breathtest(file), 1 )
 
}
