% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/richness_breakaway.R
\name{breakaway}
\alias{breakaway}
\title{Species richness estimation with breakaway}
\usage{
breakaway(
  input_data,
  cutoff = NA,
  output = NULL,
  plot = NULL,
  answers = NULL,
  print = NULL,
  ...
)
}
\arguments{
\item{input_data}{An input type that can be processed by \code{convert()}}

\item{cutoff}{The maximum frequency count to use for model fitting}

\item{output}{Deprecated; only for backwards compatibility}

\item{plot}{Deprecated; only for backwards compatibility}

\item{answers}{Deprecated; only for backwards compatibility}

\item{print}{Deprecated; only for backwards compatibility}

\item{...}{Additional arguments will be ignored; this is for backward compatibility}
}
\value{
An object of class \code{alpha_estimate}
}
\description{
breakaway is a wrapper for modern species richness estimation
for modern datasets
}
\note{
\samp{breakaway} presents an estimator of species richness that is
well-suited to the high-diversity/microbial setting. However, many microbial
datasets display more diversity than the Kemp-type models can permit. In
this case, the log-transformed \code{WLRM} diversity estimator of Rocchetti et. al.
(2011) is returned. The authors' experience suggests that some datasets that
require the log-transformed \code{WLRM} contain ``false'' diversity, that is,
diversity attributable to sequencing errors (via an inflated singleton
count). The authors encourage judicious use of diversity estimators when the
dataset may contain these errors, and recommend the use of
\code{\link{breakaway_nof1}} as an exploratory tool in this case.
}
\examples{

breakaway(apples)
breakaway(apples, plot = FALSE, output = FALSE, answers = TRUE)

}
\references{
Willis, A. and Bunge, J. (2015). Estimating diversity via
frequency ratios. \emph{Biometrics}, \bold{71}(4), 1042--1049.
}
\seealso{
\code{\link{breakaway_nof1}}; \code{\link{kemp}}; \code{\link{apples}}
}
\author{
Amy Willis
}
\keyword{diversity}
\keyword{microbial}
\keyword{models}
\keyword{nonlinear}
