\name{writeWebGL_split}
\alias{writeWebGL_split}
\title{Write WebGL with split triangles}
\usage{
writeWebGL_split(ids = rgl.ids()$id, writeIt = TRUE, verb = FALSE, ...)
}
\arguments{
  \item{ids}{- rgl ids (see \link[rgl]{rgl.ids})}

  \item{writeIt}{- (logical) write the file out}

  \item{verb}{- verbose output}

  \item{...}{- further arguments passed to
  \link[rgl]{writeWebGL}}
}
\value{
if writeIt is TRUE, then returns the value from
\link[rgl]{writeWebGL}. Otherwise, returns the split
triangles from the rgl objects
}
\description{
Adapted \link[rgl]{writeWebGL} function that splits the
triangles into 65535 vertices
}
\examples{
\dontrun{
#Brain Template from Copyright (C) 1993-2009 Louis Collins,
#McConnell Brain Imaging Centre,
#Montreal Neurological Institute, McGill University
#6th generation non-linear symmetric brain
template <- readNIfTI(system.file("MNI152_T1_2mm_brain.nii.gz", package="brainR")
, reorient=FALSE)
dtemp <- dim(template)
### 4500 - value that empirically value that presented a brain with gyri
### lower values result in a smoother surface
brain <- contour3d(template, x=1:dtemp[1], y=1:dtemp[2],
z=1:dtemp[3], level = 4500, alpha = 0.1, draw = FALSE)
drawScene.rgl(brain)
### this would be the ``activation'' or surface you want to render -
# hyper-intense white matter
contour3d(template, level = c(8200, 8250),
alpha = c(0.5, 0.8), add = TRUE, color=c("yellow", "red"))
### add text
text3d(x=dtemp[1]/2, y=dtemp[2]/2, z = dtemp[3]*0.98, text="Top")
text3d(x=dtemp[1]*0.98, y=dtemp[2]/2, z = dtemp[3]/2, text="Right")
fname <- "knitted_webGL.html"
writeWebGL_split(dir=getwd(), filename =fname,
template = system.file("my_template.html", package="brainR"), width=500,
writeIt=TRUE)
browseURL(fname)
}
}

