% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_brainGraph.R
\name{plot.brainGraph_mtpc}
\alias{plot.brainGraph_mtpc}
\title{Plot a graph with results from MTPC}
\usage{
\method{plot}{brainGraph_mtpc}(x, subgraph = "sig == 1",
  main = paste0("\\n\\n", x$outcome, ": ", x$name), subt = NULL,
  cex.main = 2, ...)
}
\arguments{
\item{x}{A \code{brainGraph_mtpc} graph object (from
\code{\link{make_glm_brainGraph}})}

\item{subgraph}{Character string specifying an equation for vertices to plot
(default: \code{NULL})}

\item{main}{Character string; the main title (default: \code{NULL})}

\item{subt}{Character string; the subtitle (default: \code{default})}

\item{cex.main}{Numeric indicating the scaling for plot title size (see
\code{\link[graphics]{par}}.}

\item{...}{Other parameters (passed to \code{\link[igraph]{plot.igraph}}).
See \code{\link[igraph]{igraph.plotting}} for details.}
}
\description{
This is a convenience function for plotting a graph based on results from
\code{\link{mtpc}}. There are a few argument defaults: to plot only those
vertices for which \eqn{A_{mtpc} > A_{crit}}; a plot title with the outcome
measure and contrast name, and to omit the plot subtitle.
}
\seealso{
Other Plotting functions: \code{\link{plot.brainGraph_GLM}},
  \code{\link{plot.brainGraph_NBS}},
  \code{\link{plot.brainGraph_mediate}},
  \code{\link{plot.brainGraph}},
  \code{\link{plot_brainGraph_gui}},
  \code{\link{plot_brainGraph_list}},
  \code{\link{plot_brainGraph_multi}}
}
\concept{Plotting functions}
