% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBS.R
\name{NBS}
\alias{NBS}
\alias{summary.NBS}
\title{Network-based statistic for brain MRI data}
\usage{
NBS(A, covars, con.mat, con.type = c("t", "f"), X = NULL,
  con.name = NULL, p.init = 0.001, N = 1000, perms = NULL,
  symm.by = c("max", "min", "avg"), alternative = c("two.sided",
  "less", "greater"), long = FALSE, ...)

\method{summary}{NBS}(object, contrast = NULL, digits = max(3L,
  getOption("digits") - 2L), ...)
}
\arguments{
\item{A}{Three-dimensional array of all subjects' connectivity matrices}

\item{covars}{A \code{data.table} of covariates}

\item{con.mat}{Numeric matrix specifying the contrast(s) of interest; if
only one contrast is desired, you can supply a vector}

\item{con.type}{Character string; either \code{'t'} or \code{'f'} (for t or
F-statistics). Default: \code{'t'}}

\item{X}{Numeric matrix, if you wish to supply your own design matrix
(default: \code{NULL})}

\item{con.name}{Character vector of the contrast name(s); if \code{con.mat}
has row names, those will be used for reporting results (default:
\code{NULL})}

\item{p.init}{Numeric; the initial p-value threshold (default: \code{0.001})}

\item{N}{Integer; number of permutations to create (default: 5e3)}

\item{perms}{Matrix of permutations, if you would like to provide your own
(default: \code{NULL})}

\item{symm.by}{Character string; how to create symmetric off-diagonal
elements (default: \code{max})}

\item{alternative}{Character string, whether to do a two- or one-sided test
(default: \code{'two.sided'})}

\item{long}{Logical indicating whether or not to return all permutation
results (default: \code{FALSE})}

\item{...}{Other arguments passed to \code{\link{brainGraph_GLM_design}}}

\item{object}{A \code{NBS} object}

\item{contrast}{Integer specifying the contrast to plot/summarize; defaults
to showing results for all contrasts}

\item{digits}{Integer specifying the number of digits to display for p-values}
}
\value{
An object of class \code{NBS} with some input arguments in addition
  to:
  \item{X}{The design matrix}
  \item{removed}{Character vector of subject ID's removed due to incomplete
    data (if any)}
  \item{T.mat}{3-d array of (symmetric) numeric matrices containing the
    statistics for each edge}
  \item{p.mat}{3-d array of (symmetric) numeric matrices containing the
    P-values}
  \item{components}{List containing data tables of the observed and permuted
    connected component sizes and P-values}
}
\description{
Calculates the \emph{network-based statistic (NBS)}, which allows for
family-wise error (FWE) control over network data, introduced for brain MRI
data by Zalesky et al. Accepts a three-dimensional array of all subjects'
connectivity matrices and a \code{data.table} of covariates, and creates a
null distribution of the largest connected component size by permuting
subjects across groups. The covariates \code{data.table} must have (at least)
a \emph{Group} column.
}
\details{
The graph that is returned by this function will have a \code{t.stat} edge
attribute which is the t-statistic for that particular connection, along with
a \code{p} edge attribute, which is the p-value for that connection.
Additionally, each vertex will have a \code{p.nbs} attribute representing
\eqn{1 - } the p-value associated with that vertex's component.
}
\examples{
\dontrun{
max.comp.nbs <- NBS(A.norm.sub[[1]], covars.dti, N=5e3)
}
}
\references{
Zalesky A., Fornito A., Bullmore E.T. (2010) \emph{Network-based
  statistic: identifying differences in brain networks}. NeuroImage,
  53(4):1197-1207.
}
\seealso{
\code{\link{brainGraph_GLM_design}, \link{brainGraph_GLM_fit_t}}

Other Group analysis functions: \code{\link{Bootstrapping}},
  \code{\link{GLM}}, \code{\link{IndividualContributions}},
  \code{\link{MediationAnalysis}},
  \code{\link{brainGraph_permute}}, \code{\link{mtpc}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Group analysis functions}
