% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial_distribution.R
\name{binomial_distribution}
\alias{binomial_distribution}
\alias{binomial_pdf}
\alias{binomial_lpdf}
\alias{binomial_cdf}
\alias{binomial_lcdf}
\alias{binomial_quantile}
\title{Binomial Distribution Functions}
\usage{
binomial_pdf(k, n, prob)

binomial_lpdf(k, n, prob)

binomial_cdf(k, n, prob)

binomial_lcdf(k, n, prob)

binomial_quantile(p, n, prob)
}
\arguments{
\item{k}{number of successes (0 <= k <= n)}

\item{n}{number of trials (n >= 0)}

\item{prob}{probability of success on each trial (0 <= prob <= 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Binomial distribution.
}
\examples{
# Binomial dist ribution with n = 10, prob = 0.5
binomial_pdf(3, 10, 0.5)
binomial_lpdf(3, 10, 0.5)
binomial_cdf(3, 10, 0.5)
binomial_lcdf(3, 10, 0.5)
binomial_quantile(0.5, 10, 0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/binomial_dist.html}{Boost Documentation} for more details on the mathematical background.
}
