% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_stacked_data.R
\name{generate_stacked_data}
\alias{generate_stacked_data}
\title{Generation of Stacked Data by Subgroups}
\usage{
generate_stacked_data(
  base_model,
  subgroup_model,
  data,
  resptype = c("survival", "binary")
)
}
\arguments{
\item{base_model}{(\code{formula})\cr the formula of the basic model that is going
to be fitted. Depending on \code{resptype} it will be the formula corresponding
to a coxph model or to a glm model. In the case of "survival" a formula like
Surv(time, status) ~ trt would be expected  and in the "binary" case a
formula like y ~ trt.}

\item{subgroup_model}{(\code{formula})\cr the formula with all the subgroup
variables.}

\item{data}{(\verb{data frame})\cr the data frame with the variables.}

\item{resptype}{(\code{string})\cr the type of data used. Can be "survival"
or "binary".}
}
\value{
Data frame of the stacked data.
}
\description{
Function to generate stacked data by the subgroups considered in the model.
}
\examples{
generate_stacked_data(Surv(tt_pfs, ev_pfs) ~ arm, ~ x_1 + x_2, example_data, "survival")
}
