% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst.R
\name{fst}
\alias{fst}
\title{Calculate FST for the admixed individuals}
\usage{
fst(Q, F, w)
}
\arguments{
\item{Q}{The \eqn{n \times k}{n-by-k} admixture proportion matrix}

\item{F}{The length-\eqn{k} vector of subpopulation inbreeding coefficients}

\item{w}{The length-\eqn{n} vector of weights for individuals that define \eqn{F_{ST}}{FST} (default uniform weights)}
}
\value{
The \eqn{F_{ST}}{FST} of the admixed individuals
}
\description{
Given the admixture proportion matrix \eqn{Q} for \eqn{n} individuals and \eqn{k} intermediate subpopulations, the vector of intermediate inbreeding coefficients \eqn{F} (per-subpopulation \eqn{F_{ST}}{FST}'s), and weights for individuals, this function returns the \eqn{F_{ST}}{FST} of the admixed individuals.
This \eqn{F_{ST}}{FST} equals the weighted mean of the diagonal of the coancestry matrix (see \code{\link{coanc}}).
}
\examples{
# set desired parameters
n <- 1000 # number of individuals
k <- 10 # number of intermediate subpopulations
s <- 0.5 # desired bias coefficient
sigma <- 1 # for 1D admixture model
# differentiation of intermediate subpopulations
F <- (1:k)/k
# construct final admixture proportions
Q <- q1d(n=n, k=k, sigma=sigma)
# lastly, calculate Fst!!! (uniform weights in this case)
F <- fst(Q, F)

}
