% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnma.R
\docType{package}
\name{bnma-package}
\alias{bnma-package}
\title{bnma: A package for network meta analysis using Bayesian methods}
\description{
A package for running Bayesian network meta analysis
}
\details{
Network meta-analysis or mixed treatment comparison (MTC) is a method that allows simultaneous comparison of more than two treatments.
We use a Bayesian approach to combine both direct and indirect evidence as in Dias et al. 2013a.
This package is a user friendly application that can run network meta analysis models without having to code a JAGS model.
The program takes the input data and transforms it to a suitable format of analysis, generates a JAGS model and reasonable
initial values and runs the model through the rjags package.
The focus of this package was inclusion of multinomial response and various options for adding covariates and/or baseline risks effects.
Also, while sampling, the package uses Gelman-Rubin convergence criteria to decide whether to continue sampling or not.
Furthermore, package includes different models such as contrast based models and unrelated mean effects (UME) model and nodesplitting model to test for inconsistency.
}
\references{
A.J. Franchini, S. Dias, A.E. Ades, J.P. Jansen, N.J. Welton (2012), \emph{Accounting for correlation in network meta-analysis with multi-arm trials}, Research Synthesis Methods 3(2):142-160. [\url{https://doi.org/10.1002/jrsm.1049}]

S. Dias, A.J. Sutton, A.E. Ades, and N.J. Welton (2013a), \emph{A Generalized Linear Modeling Framework for Pairwise and Network Meta-analysis of Randomized Controlled Trials}, Medical Decision Making 33(5):607-617. [\url{https://doi.org/10.1177/0272989X12458724}]

S. Dias, A.J. Sutton, A.E. Ades, and N.J. Welton (2013b), \emph{Heterogeneity-Subgroups, Meta-Regression, Bias, and Bias-Adjustment}, Medical Decision Making 33(5):618-640. [\url{https://doi.org/10.1177/0272989X13485157}]

S. Dias, N.J. Welton, D.M. Caldwellb, A.E. Ades (2010), \emph{Checking consistency in mixed treatment}, Statistics in Medicine 29(7-8, Sp. Iss. SI): 932-944. [\url{https://doi.org/10.1002/sim.3767}]

S. Dias, N.J. Welton, A.J. Sutton, D.M. Caldwell, G. Lu, and A.E. Ades (2013), \emph{Evidence synthesis for decision making 4: inconsistency in networks of evidence based on randomized controlled trials}, Medical Decision Making 33(5):641-656. [\url{https://doi.org/10.1177/0272989X12455847}]

C.H. Schmid, T.A. Trikalinos, I. Olkin (2014), \emph{Bayesian network meta-analysis for unordered categorical outcomes with incomplete data}, Research Synthesis Methods 5(2):162-185. [\url{https://doi.org/10.1002/jrsm.1103}]

A. Gelman, D.B. Rubin (1992), \emph{Inference from iterative simulation using multiple sequences}, Statistical Science 7(4):457-472. [\url{http://dx.doi.org/10.1214/ss/1177011136}]

D.J. Spiegelhalter, N.G. Best, and B.P. Carlin (1998), \emph{Bayesian deviance, the effective nunmber of parameters, and the comparison of arbitrarily complex models}, Technical report, MRC Biostatistics Unit, Cambridge, UK.

F.A. Achana, N.J. Cooper, S. Dias, G. Lu, S.J.C. Rice, D. Kendrick, A.J. Sutton (2012), \emph{Extending methods for investigating the relationship between treatment effect and baseline risk from pairwise meta-analysis to network meta-analysis}, Statistics in Medicine 32(5):752-771. [\url{https://doi.org/10.1002/sim.5539}]

F.A. Achana, N.J. Cooper, S. Bujkiewicz, S.J. Hubbard, D. Kendrick, D.R. Jones, A.J. Sutton (2014), \emph{Network meta-analysis of multiple outcomes measures accounting for borrowing of information across outcomes}, BMC Medical Research Methodology 14:92. [\url{https://doi.org/10.1186/1471-2288-14-92}]

G. Salanti, A.E. Ades, J.P.A. Ioannidisa (2011), \emph{Graphical methods and numerical summaries for presenting results from multiple-treatment meta-analysis: an overview and tutorial}, Journal of Clinical Epidemiology 64(2):163-171. [\url{https://doi.org/10.1016/j.jclinepi.2010.03.016}]

G. van Valkenhoef, G. Lu, B. de Brock, H. Hillege, A.E. Ades, and N.J. Welton (2012), \emph{Automating network meta-analysis}, Research Synthesis Methods 3(4):285-299. [\url{https://doi.org/10.1002/jrsm.1054}]

N.J. Cooper, A.J. Sutton, D. Morris, A.E. Ades, N.J. Welton (2009), \emph{Addressing between-study heterogeneity and inconsistency in mixed treatment comparisons: Application to stroke prevention treatments in individuals with non-rheumatic atrial fibrillation}, Statistics in Medicine 28:1861-1881. [\url{https://doi.org/10.1002/sim.3594}]

W. Viechtbauer (2010), \emph{Conducting meta-analyses in R with the metafor package}, Journal of Statistical Software, 36(3):1-48. [\url{https://doi.org/10.18637/jss.v036.i03}]
}
\seealso{
\code{\link{network.data}}, \code{\link{network.run}}
}
