% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-plots.R
\name{blr_plot_diag_difdev}
\alias{blr_plot_diag_difdev}
\title{Delta deviance plot}
\usage{
blr_plot_diag_difdev(model, point_color = "blue",
  title = "Delta Deviance Plot", xaxis_title = "id",
  yaxis_title = "Delta Deviance")
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{point_color}{Color of the points.}

\item{title}{Title of the plot.}

\item{xaxis_title}{X axis label.}

\item{yaxis_title}{Y axis label.}
}
\description{
Diagnostics for detecting ill fitted observations.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

blr_plot_diag_difdev(model)

}
