% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-multi-model-fit-stats.R
\name{blr_multi_model_fit_stats}
\alias{blr_multi_model_fit_stats}
\alias{blr_multi_model_fit_stats.default}
\title{Multi model fit statistics}
\usage{
blr_multi_model_fit_stats(model, ...)

\method{blr_multi_model_fit_stats}{default}(model, ...)
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{...}{Objects of class \code{glm}.}
}
\value{
A tibble.
}
\description{
Measures of model fit statistics for multiple models.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

model2 <- glm(honcomp ~ female + read + math, data = hsb2,
family = binomial(link = 'logit'))

blr_multi_model_fit_stats(model, model2)

}
\seealso{
Other model fit statistics: \code{\link{blr_model_fit_stats}},
  \code{\link{blr_pairs}}, \code{\link{blr_rsq_adj_count}},
  \code{\link{blr_rsq_cox_snell}},
  \code{\link{blr_rsq_effron}},
  \code{\link{blr_rsq_mcfadden_adj}},
  \code{\link{blr_rsq_mckelvey_zavoina}},
  \code{\link{blr_rsq_nagelkerke}},
  \code{\link{blr_test_lr}}
}
