% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_hugo}
\alias{install_hugo}
\alias{update_hugo}
\title{Install Hugo}
\usage{
install_hugo(version = "latest", extended = TRUE, force = FALSE, ...)

update_hugo()
}
\arguments{
\item{version}{The Hugo version number, e.g., \code{0.26}; the special value
\code{latest} means the latest version (fetched from Github releases).
Alternatively, this argument can take a file path of the zip archive or
tarball of the Hugo installer that has already been downloaded from Github,
in which case it will not be downloaded again.}

\item{extended}{Whether to use extended version of Hugo that has SCSS/SASS
support. You only need the extended version if you want to edit SCSS/SASS.}

\item{force}{Whether to reinstall Hugo if the specified version has been
installed.}

\item{...}{Ignored.}
}
\description{
Download the appropriate Hugo executable for your platform from Github and
try to copy it to a system directory so \pkg{blogdown} can run the
\command{hugo} command to build a site.
}
\details{
This function tries to install Hugo to \code{Sys.getenv('APPDATA')} on
Windows, \file{~/Library/Application Support} on macOS, and
\file{~/.local/share} on other platforms (such as Linux). The \command{hugo}
executable is installed to a subdirectory with the Hugo version number being
its name, e.g., \file{~/Library/Application Support/Hugo/0.76.5}. If these
directories are not writable, the R package directory \file{Hugo} of
\pkg{blogdown} will be used. If it still fails, you have to install Hugo by
yourself and make sure it can be found via the environment variable
\code{PATH}.

This is just a helper function and may fail to choose the correct Hugo
executable for your operating system, especially if you are not on Windows or
macOS or a major Linux distribution. When in doubt, read the Hugo
documentation and install it by yourself: \url{https://gohugo.io}.

If you want to install Hugo to a custom path, you can set the global option
\code{blogdown.hugo.dir} to a directory to store the Hugo executable before
you call \code{install_hugo()}, e.g., \code{options(blogdown.hugo.dir =
'~/Downloads/Hugo')}. This may be useful for you to use a specific version of
Hugo for a specific website. You can set this option per project. See
\href{https://bookdown.org/yihui/blogdown/global-options.html}{Section 1.4
Global options} for details, or store a copy of Hugo on a USB Flash drive
along with your website.
}
\note{
For macOS users, you are not recommended to install Hugo via Homebrew,
  because you may accidentally update it to the latest version, which might
  break your existing sites.
}
\seealso{
\code{\link{remove_hugo}()} to remove Hugo.
}
