% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difference.R
\name{vb_difference}
\alias{vb_difference}
\title{Calculate differences in bloc contributions}
\usage{
vb_difference(
  vbdf,
  estimates = grep("prob|pr_turnout|pr_votedem|pr_voterep|cond_rep|net_rep",
    names(vbdf), value = TRUE),
  sort_col = "year"
)
}
\arguments{
\item{vbdf}{data.frame holding the results of voting bloc analyses.}

\item{estimates}{character vector naming the column(s) in \code{vbdf} with
which to compute differences.}

\item{sort_col}{character vector naming the column(s) in \code{vbdf} to use
for sorting before calling \link[base]{diff}.}
}
\value{
A \code{vbdf} object, plus two types of columns:
for each column named in \code{estimates}, a column named \code{diff_*} containing the
difference in each estimate across \code{sort_col} values,
\code{comp}, which contains a string tag for the rows compared (e.g., 2020-2016),

A \code{vbdf} object.
}
\description{
Use vbdf output to calculate differences
in blocs' net Republican vote contributions.
}
