% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blkboxPerformance.R
\name{Performance}
\alias{Performance}
\title{blkbox Performance.}
\usage{
Performance(object, metric = "AUROC", consensus = FALSE)
}
\arguments{
\item{object}{the blkboxCV or blkbox output}

\item{metric}{Which metric will be used for performance. Area under the Receiver operating curve = "AUROC", Accuracy = "ACC", Error rate = "ERR", Matthews correlation coefficient = "MCC", F-1 score = "F-1". default = "AUROC".}

\item{consensus}{if the process was repeated it will calculate the consensus vote for each sample across the repititons before then calculating the performance across all samples. Default is False.}
}
\description{
Determines the performance of each model within the blkbox or blkboxCV output. Can choose from a range of performance metrics.
}
\examples{
\donttest{
Performance(blkbox(...), metric = "AUROC")
Performance(blkboxCV(...), metric = "ERR")
}
}
\author{
Zachary Davies, Boris Guennewig
}
\keyword{ACC.}
\keyword{AUROC,}
\keyword{ERR,}
\keyword{F-1,}
\keyword{MCC,}
\keyword{blkbox,}
\keyword{performance,}

