% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_social_links.R
\name{block_social_links}
\alias{block_social_links}
\title{A block of social sharing icons with links}
\usage{
block_social_links(...)
}
\arguments{
\item{...}{One or more calls to \code{social_link()}.}
}
\description{
With \code{block_social_links()}, we can create a block of social sharing links
and links to websites, email, or RSS feeds. The function can accept as many
\code{social_link()} calls as seen fit to email. Like all \verb{block_*()} functions,
\code{block_social_links()} must be placed inside of \code{blocks()} and the resultant
\code{blocks} object can be provided to the \code{body}, \code{header}, or \code{footer}
arguments of \code{compose_email()}.
}
\examples{
# Create an email message with some
# articles in the `body`; in the footer,
# add some social sharing icons linking
# to web content using `block_social_links()`
email <-
  compose_email(
    body =
      blocks(
        block_title("Exciting Travel Destinations"),
        block_articles(
          article(
            image = "https://i.imgur.com/dxSXzGb.jpg",
            title = "Hong Kong",
            content =
              "Once home to fishermen and farmers,
              modern Hong Kong is a teeming,
              commercially-vibrant metropolis where
              Chinese and Western influences fuse."
          ),
          article(
            image = "https://i.imgur.com/bJzVIrG.jpg",
            title = "Australia",
            content =
              "Australia ranks as one of the best
              places to live in the world by all
              indices of income, human development,
              healthcare, and civil rights."
          )
        )
      ),
    footer =
      blocks(
        block_text("Thanks for reading! Find us here:"),
        block_social_links(
          social_link(
            service = "pinterest",
            link = "https://www.pinterest.ca/TravelLeisure/",
            variant = "color"
          ),
          social_link(
            service = "tripadvisor",
            link = "https://www.tripadvisor.ca/TravelersChoice",
            variant = "color"
          )
        )
      )
  )

if (interactive()) email

}
