% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fast_history_compute}
\alias{fast_history_compute}
\title{Computes cumulative history}
\usage{
fast_history_compute(df, normalized_tau, mixed_state, history_init)
}
\arguments{
\item{df}{DataFrame with \code{"state"} (integer, 1 and 2 clear state, 3 - mixed state), \code{"duration"} (double),
\code{"irandom"} (integer, 1-based index of a random cluster), \code{"run_start"} (integer, 1 for the first entry of
the run, 0 otherwise), \code{"session_tmean"} (double)}

\item{normalized_tau}{DoubleVector A normalized tau value for each random cluster / individual. Thus, its length must be
equal to the number of unique indexes in \code{df["irandom"]}.}

\item{mixed_state}{DoubleVector A values used for the mixed state for each random cluster / individual.
Thus, its length must be equal to the number of unique indexes in \code{df["irandom"]}.}

\item{history_init}{DoubleVector, size 2. Initial values of history for a run.}
}
\value{
NumericMatrix, size \code{df.nrows()} × 2. Computed history values for each state.
}
\description{
Computes cumulative history based on common \code{history} values and
\code{normalized_tau} and \code{mixed_state} that are defined for each
random cluster / individual.
}
\examples{
df <- preprocess_data(br_singleblock, state="State", duration="Duration")
fast_history_compute(df, 1, 0.5, c(0, 0))
}
