% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jacobians.R
\name{jac.log}
\alias{jac.log}
\title{Jacobian for log transform}
\usage{
jac.log(x, log = TRUE)
}
\arguments{
\item{x}{value at which to evaluate \eqn{J(x)}}

\item{log}{TRUE to return \eqn{log(J(x))}}
}
\description{
Let \eqn{X=log(Y)} be a transformation of a random variable \eqn{Y}.  
This function computes the jacobian \eqn{J(x)} when using the density of 
\eqn{Y} to evaluate the density of \eqn{X} via
\deqn{f(x) = f_y(exp(x)) J(x)}
where 
\deqn{J(x) = d/dx exp(x).}
}
\examples{
jac.log(1)

}
