% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotExploration.R
\name{plotExploration}
\alias{plotExploration}
\title{plotExploration}
\usage{
plotExploration(
  echoData = NULL,
  timeRange = NULL,
  targetTimeZone = "Etc/GMT0",
  manualBlindTimes = NULL,
  visibilityData = NULL,
  protocolData = NULL,
  sunriseSunset = NULL,
  maxAltitude = NULL,
  filePath = NULL
)
}
\arguments{
\item{echoData}{dataframe with the echo data from the data list created by
the function ‘extractDBData’ or a subset of it created by the function
‘filterEchoData’}

\item{timeRange}{optional list of string vectors length 2, start and end
time of the time ranges that should be plotted. The date/time format is
“yyyy-MM-dd hh:mm”. If not set, all echo data is plotted in one plot.
Note: Too long time-ranges may produce an error if the created image is too
large and the function can’t allocate the file.}

\item{targetTimeZone}{"Etc/GMT0" String specifying the target time zone.
Default is "Etc/GMT0".}

\item{manualBlindTimes}{optional dataframe with the manual blind times
created by the function ‘loadManualBlindTimes’. If not set, manual blind
times are not shown in the plot.}

\item{visibilityData}{optional dataframe with the visibility data created by
the function ‘extractDBData’. If not set, visibility data are not shown in
the plot.}

\item{protocolData}{optional dataframe with the protocol data used to filter
the echoes, created by the function ‘extractDBData’ or a subset of it created
by the function ‘filterProtocolData’. If not set, periods without a protocol
are not shown in the plot.}

\item{sunriseSunset}{optional dataframe with sunrise/sunset and civil
twilight times created by the function ‘twilight’. If not set, day/night
times are not shown in the plot.}

\item{maxAltitude}{optional numeric, fixes the maximum value of the y-Scale
of the plot to the given value. If negative or not set, the y-Scale is
auto-scaled.}

\item{filePath}{character string, path of the directory where the plot
should be saved. The function ‘savePlotToFile’ is used to save the plots as
png files with an auto-generated filename.}
}
\value{
png files stored in the directory specified in 'filePath'
}
\description{
This function creates a time series plot showing all of the
observed echoes at their respective altitudes. These plots are helpful to
roughly visually explore your data (and for example spot oddities).
}
\examples{
\dontrun{
#' # Set server, database, and other input settings
# ===========================================================================
  dbServer       = "MACHINE\\\\SERVERNAME"     # Set the name of your SQL server
  dbName         = "db_Name"                   # Set the name of your database
  dbDriverChar   = "SQL Server"                # Set either "SQL Server" or "PostgreSQL"
  mainOutputDir  = file.path(".", "results")
  radarTimeZone  = "Etc/GMT0"
  targetTimeZone = "Etc/GMT0"
  listOfRfFeaturesToExtract = c(167, 168)
  siteLocation   = c(47.494427, 8.716432)
  sunOrCivil     = "civil"
 
# Get data
# ===========================================================================
  dbData = extractDbData(dbDriverChar                   = dbDriverChar,
                         dbServer                       = dbServer, 
                         dbName                         = dbName, 
                         saveDbToFile                   = TRUE,
                         dbDataDir                      = mainOutputDir,
                         radarTimeZone                  = radarTimeZone,
                         targetTimeZone                 = targetTimeZone,
                         listOfRfFeaturesToExtract      = listOfRfFeaturesToExtract,
                         siteLocation                   = siteLocation, 
                         sunOrCivil                     = sunOrCivil)
                         
# Get manual blindtimes
# ===========================================================================
  data("manualBlindTimes")
  cManualBlindTimes = manualBlindTimes

# Make Plot 
# ===========================================================================
  timeRangePlot = list(c("2021-01-15 00:00", "2021-01-22 00:00"),
                       c("2021-01-23 00:00", "2021-01-31 00:00"))
  plotExploration(echoData         = dbData$echoData, 
                  timeRange        = timeRangePlot, 
                  targetTimeZone   = "Etc/GMT0",
                  manualBlindTimes = cManualBlindTimes, 
                  visibilityData   = dbData$visibilityData, 
                  protocolData     = dbData$protocolData, 
                  sunriseSunset    = dbData$sunriseSunset, 
                  maxAltitude      = -1, 
                  filePath         = "./") 
}

}
\author{
Fabian Hertner, \email{fabian.hertner@swiss-birdradar.com};
Birgen Haest, \email{birgen.haest@vogelwarte.ch}
}
