% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set_read}
\alias{set_read}
\title{Read a data set from a data-sheet and turn it into a multi-column tibble.}
\usage{
set_read(file_name = "set_#NUM#.csv", path = ".", num = 1, sep = ",",
  dec = ".", cols = 0, rows = 0, additional_vars = vector(),
  additional_sep = "[^[:alnum:]]+")
}
\arguments{
\item{file_name}{Name of the file from which to read the data. May contain
"#NUM#" as a placeholder if you have multiple files.}

\item{path}{The path to the file (no trailing "/" or "\" !).}

\item{num}{Number of the set to read, inserted for "#NUM#".}

\item{sep}{Separator used in the csv-file, either "," or ";" (see
\code{\link[utils:read.csv]{utils::read.csv()}}).}

\item{dec}{The character used for decimal points (see \code{\link[utils:read.csv]{utils::read.csv()}}).
"AUTO" will result in "." if \code{sep} is "," and "," for ";".}

\item{cols}{Number of columns in the input matrix (\code{0} means auto-detect).}

\item{rows}{Number of rows containing values (not names / additional data)
in the input matrix (\code{0} means auto-detect).}

\item{additional_vars}{Vector of strings containing the names for the
additional columns.}

\item{additional_sep}{String / RegExp that separates additional vars, e.g.:
\code{"ID_blue_cold"} with \code{additional_sep = "_"} will be separated
into three columns containing \code{"ID"}, \code{"blue"} and \code{"cold"}.
If the separated data would exceed the columns in \code{additional_vars}
the last column will contain a string with separator (e.g.: \code{"blue_cold"}).
If data is missing \code{NA} is inserted.}
}
\value{
A tibble containing (at minimum) \code{set}, \code{position}, \code{sample_id},
\code{name} and \code{value}.
}
\description{
Read a matrix of values from a csv sheet and sort them into a tibble. You
can name the values and encode several additional properties into the name,
which be split into several columns. Please refer to the vignette
(\code{browseVignettes("roxygen2")}) and examples below for in-depth explanation
and the whys and hows.
}
\examples{
# a file containing only values
read.csv(
  file = system.file("extdata", "values.csv", package = "bioset"),
  header = FALSE,
  colClasses = "character"
)

# read into a tibble
set_read(
  file_name = "values_names.csv",
  path = system.file("extdata", package = "bioset"),
)

# file containing names
read.csv(
  file = system.file("extdata", "values_names.csv", package = "bioset"),
  header = FALSE,
  colClasses = "character"
)

# read a file containing labels and store those in column "name"
set_read(
  file_name = "values_names.csv",
  path = system.file("extdata", package = "bioset"),
  additional_vars = c("name")
)

# file with names and properties
read.csv(
  file = system.file(
    "extdata", "values_names_properties.csv", package = "bioset"),
  header = FALSE,
  colClasses = "character"
)

# read a file containing labels and properties and store those in columns
# "name" and "time"
# splits names by every character that's not A-Z, a-z, 0-9
# to change that behaviour use additional_sep
set_read(
  file_name = "values_names_properties.csv",
  path = system.file("extdata", package = "bioset"),
  additional_vars = c("name", "time")
)

# read file "set_1.csv" containing labels
set_read(
  num = 1,
  path = system.file("extdata", package = "bioset"),
  additional_vars = c("name", "time")
)

# read file "set_2.csv" containing labels
set_read(
  num = 2,
  path = system.file("extdata", package = "bioset"),
  additional_vars = c("name", "time")
)

# read file "plate_2.csv" containing labels
set_read(
  num = 2,
  file_name = "plate_#NUM#.csv",
  path = system.file("extdata", package = "bioset"),
  additional_vars = c("name", "time")
)

}
\seealso{
Other set functions: \code{\link{set_calc_concentrations}},
  \code{\link{set_calc_variability}},
  \code{\link{sets_read}}
}
