% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_PlotRangeSize.R
\name{bm_PlotRangeSize}
\alias{bm_PlotRangeSize}
\title{Plot species range change}
\usage{
bm_PlotRangeSize(
  bm.range,
  do.count = TRUE,
  do.perc = TRUE,
  do.maps = TRUE,
  do.mean = TRUE,
  do.plot = TRUE,
  row.names = c("Species", "Dataset", "Run", "Algo")
)
}
\arguments{
\item{bm.range}{an object returned by the \code{\link{BIOMOD_RangeSize}} function}

\item{do.count}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the count plot is to be computed or not}

\item{do.perc}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the percentage plot is to be computed or not}

\item{do.maps}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the maps plot is to be computed or not}

\item{do.mean}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the mean maps plot is to be computed or not}

\item{do.plot}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the plots are to be rendered or not}

\item{row.names}{(\emph{optional, default} \code{c('Species', 'Dataset', 'Run', 'Algo')}) \cr 
A \code{vector} containing tags matching \code{bm.range$Compt.By.Models} rownames splitted by 
'_' character}
}
\value{
A \code{list} containing one or several \code{data.frame} and the corresponding 
\code{ggplot} object representing species range change.
}
\description{
This function represents species range change from object that can be obtained 
from \code{\link{BIOMOD_RangeSize}} function. Several graphics can be obtained, representing 
global counts or proportions of gains / losses, as well as spatial representations (see Details).
}
\details{
4 plots can be obtained with this function :
\describe{
  \item{Count barplot}{representing absolute number of locations (pixels) lost, stable and 
  gained}
  \item{Percentage barplot}{representing percentage of locations (pixels) lost, stable, and 
  the corresponding Species Range Change (\code{PercGain - PercLoss})}
  \item{SRC models maps}{representing spatially locations (pixels) lost, stable and 
  gained for each single distribution model}
  \item{SRC community averaging maps}{representing spatially locations (pixels) lost, stable 
  and gained, taking the majoritary value across single distribution models (and representing 
  the percentage of models' agreement)}
}
\emph{Please see \code{\link{BIOMOD_RangeSize}} function for more details about the values.}
}
\examples{

# Load species occurrences (6 species available)
myFile <- system.file('external/species/mammals_table.csv', package = 'biomod2')
DataSpecies <- read.csv(myFile, row.names = 1)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
myFiles <- paste0('external/bioclim/current/bio', c(3, 4, 7, 11, 12), '.grd')
myExpl <- raster::stack(system.file(myFiles, package = 'biomod2'))

\dontshow{
myExtent <- raster::extent(0,30,45,70)
myExpl <- raster::stack(raster::crop(myExpl, myExtent))
}

# ---------------------------------------------------------------
file.out <- paste0(myRespName, "/", myRespName, ".AllModels.models.out")
if (file.exists(file.out)) {
  myBiomodModelOut <- get(load(file.out))
} else {

  # Format Data with true absences
  myBiomodData <- BIOMOD_FormatingData(resp.var = myResp,
                                       expl.var = myExpl, 
                                       resp.xy = myRespXY,
                                       resp.name = myRespName)

  # Create default modeling options
  myBiomodOptions <- BIOMOD_ModelingOptions()

  # Model single models
  myBiomodModelOut <- BIOMOD_Modeling(bm.format = myBiomodData,
                                      modeling.id = 'AllModels',
                                      models = c('RF', 'GLM'),
                                      bm.options = myBiomodOptions,
                                      nb.rep = 2,
                                      data.split.perc = 80,
                                      metric.eval = c('TSS','ROC'),
                                      var.import = 3,
                                      do.full.models = FALSE,
                                      seed.val = 42)
}

file.proj <- paste0(myRespName, "/proj_Current/", myRespName, ".Current.projection.out")
if (file.exists(file.proj)) {
  myBiomodProj <- get(load(file.proj))
} else {

  # Project single models
  myBiomodProj <- BIOMOD_Projection(bm.mod = myBiomodModelOut,
                                    proj.name = 'Current',
                                    new.env = myExpl,
                                    models.chosen = 'all',
                                    metric.binary = 'all',
                                    metric.filter = 'all',
                                    build.clamping.mask = TRUE)
}


# ---------------------------------------------------------------
# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
myFiles = paste0('external/bioclim/future/bio', c(3, 4, 7, 11, 12), '.grd')
myExplFuture = raster::stack(system.file(myFiles, package = 'biomod2'))
\dontshow{
myExtent <- raster::extent(0,30,45,70)
myExplFuture <- raster::stack(raster::crop(myExplFuture, myExtent))
}

# Project onto future conditions
myBiomodProjectionFuture <- BIOMOD_Projection(bm.mod = myBiomodModelOut,
                                              proj.name = 'Future',
                                              new.env = myExplFuture,
                                              models.chosen = 'all',
                                              metric.binary = 'TSS',
                                              build.clamping.mask = TRUE)

# Load current and future binary projections
CurrentProj <- raster::stack("GuloGulo/proj_Current/proj_Current_GuloGulo_TSSbin.grd")
FutureProj <- raster::stack("GuloGulo/proj_Future/proj_Future_GuloGulo_TSSbin.grd")

# Compute differences
myBiomodRangeSize <- BIOMOD_RangeSize(proj.current = CurrentProj, proj.future = FutureProj)


# ---------------------------------------------------------------
myBiomodRangeSize$Compt.By.Models
plot(myBiomodRangeSize$Diff.By.Pixel)

# Represent main results 
bm_PlotRangeSize(bm.range = myBiomodRangeSize)


}
\seealso{
\code{\link{BIOMOD_RangeSize}}

Other Secundary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CVnnet}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_VariablesImportance}()}

Other Plot functions: 
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()}
}
\author{
Maya Gueguen
}
\concept{Plot functions}
\concept{Secundary functions}
\keyword{"species}
\keyword{change"}
\keyword{gain}
\keyword{ggplot}
\keyword{loss}
\keyword{projections}
\keyword{range}
