% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensembl_ftp_generics.R
\name{getENSEMBL}
\alias{getENSEMBL}
\title{Download sequence or annotation from ENSEMBL}
\usage{
getENSEMBL(
  organism,
  type = "dna",
  id.type = "toplevel",
  release = NULL,
  path,
  format
)
}
\arguments{
\item{organism}{Organism selector id,
there are three options to characterize an organism:
\itemize{
\item by \code{scientific name}: e.g. \code{organism = "Homo sapiens"}
\item by \code{database specific accession identifier}: e.g. \code{organism = "GCF_000001405.37"} (= NCBI RefSeq identifier for \code{Homo sapiens})
\item by \code{taxonomic identifier from NCBI Taxonomy}: e.g. \code{organism = "9606"} (= taxid of \code{Homo sapiens})
}}

\item{type}{character, biological sequence type (e.g. "dna", "cds")}

\item{id.type}{a character, default "toplevel". id type of assembly, either "toplevel" or "primary_assembly" usually.}

\item{release}{a numeric, the database release version of ENSEMBL (\code{db = "ensembl"}). Default is \code{release = NULL} meaning
that the most recent database version is used. \code{release = 75} would for human would give the stable
GRCh37 release in ensembl. Value must be > 46, since ensembl did not structure their data
if the standard format before that.}

\item{path}{location where file shall be stored.}

\item{format}{"gff3", alternative "gtf" for ensembl.}
}
\value{
either a character path to downloaded file, or a logical FALSE, specifying failure.
}
\description{
Backend function for retrieving files sequence and annotation
files from the ENSEMBL ftp server
}
\author{
Hajk-Georg Drost
}
