% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_secondary_models.R
\name{fit_secondary_growth}
\alias{fit_secondary_growth}
\title{Fit secondary growth models}
\usage{
fit_secondary_growth(
  fit_data,
  starting_point,
  known_pars,
  sec_model_names,
  transformation = "sq",
  check = TRUE,
  ...
)
}
\arguments{
\item{fit_data}{Tibble with the data used for the fit. It must have
one column named \code{mu} with the estimated growth rate and as many columns
as needed with the environmental factors.}

\item{starting_point}{Named vector with initial values for the model parameters
to estimate from the data. The growth rate under optimum conditions must be named
\code{mu_opt}. The rest must be called 'env_factor'+'_'+'parameter'. For instance,
the minimum pH for growth is 'pH_xmin'.}

\item{known_pars}{Named vector of fixed model parameters. Must be named using the
same convention as \code{starting_point}.}

\item{sec_model_names}{Named character vector defining the secondary model
for each environmental factor.}

\item{transformation}{Character defining the tranformation of \code{mu} for
model fitting. One of \code{sq} (square root; default), \code{log} (log-transform) or
\code{none} (no transformation).}

\item{check}{Whether to do some basic checks (TRUE by default).}

\item{...}{Additional arguments passed to \code{\link{modFit}}.}
}
\value{
An instance of \code{\link{FitSecondaryGrowth}}.
}
\description{
Fits a secondary growth model to a set of growth rates obtained experimentally.
Modelling is done according to the gamma concept proposed by Zwietering (1992)
and cardinal parameter models.
}
\examples{
## We use the data included in the package

data("example_cardinal")

## Define the models to fit

sec_model_names <- c(temperature = "Zwietering", pH = "CPM")

## Any model parameter can be fixed

known_pars <- list(mu_opt = 1.2, temperature_n = 1,
    pH_n = 2, pH_xmax = 6.8, pH_xmin = 5.2)

## Initial values must be given for every other parameter

my_start <- list(temperature_xmin = 5, temperature_xopt = 35,
    pH_xopt = 6.5)

## We can now call the fitting function

fit_cardinal <- fit_secondary_growth(example_cardinal, my_start, known_pars, sec_model_names)

## With summary, we can look at the parameter estimates

summary(fit_cardinal)

## The plot function compares predictions against observations

plot(fit_cardinal)

## Passing which = 2, generates a different kind of plot

plot(fit_cardinal, which = 2)
plot(fit_cardinal, which = 2, add_trend = TRUE)

}
