% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/write-feature-table.R
\docType{methods}
\name{write.FeatureTable}
\alias{write.FeatureTable}
\alias{write.FeatureTable,gbRecord-method}
\alias{write.FeatureTable,gbFeatureTable-method}
\title{Write GenBank records or features to file in Feature Table format}
\usage{
write.FeatureTable(x, file, tablename = "", dbname = "", sequence = FALSE,
  append = FALSE, ...)

\S4method{write.FeatureTable}{gbRecord}(x, file, tablename = "",
  dbname = "", sequence = FALSE, append = FALSE)

\S4method{write.FeatureTable}{gbFeatureTable}(x, file, tablename = "",
  dbname = "", sequence = FALSE, append = FALSE)
}
\arguments{
\item{x}{A \code{\linkS4class{gbRecord}} instance.}

\item{file}{A connection or a character string naming the file to write to.}

\item{tablename}{Optional table name to appear in the first line
of the feature table.}

\item{dbname}{Data base name associated with the CDS qualifier protein_id.}

\item{sequence}{if \code{TRUE}, additionally output a fasta file.}

\item{append}{if \code{TRUE} the data is appended to the connection.}

\item{...}{Additional arguments passed to methods.}
}
\description{
Feature Tables are simple five-column tab-delimited tables specifying the
location and type of each feature. They can be used as input for tbl2asn
or Sequin to generate annotation.
}
\examples{
\dontrun{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
write.FeatureTable(x, file = "data/marine_metagenome.tbl")
}
}
