% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeature-class.R,
%   R/gbFeatureTable-class.R, R/gbRecord-class.R, R/gbRecordList-class.R
\docType{methods}
\name{ranges}
\alias{ranges}
\alias{ranges,gbFeature-method}
\alias{ranges,gbFeatureTable-method}
\alias{ranges,gbRecord-method}
\alias{ranges,gbRecordList-method}
\title{Extract features as \code{"\linkS4class{GRanges}"} objects.}
\usage{
ranges(x, join = FALSE, key = TRUE, include = "none", exclude = "", ...)

\S4method{ranges}{gbFeature}(x, join = FALSE, key = TRUE,
  include = "none", exclude = "", ...)

\S4method{ranges}{gbFeatureTable}(x, join = FALSE, key = TRUE,
  include = "none", exclude = "", ...)

\S4method{ranges}{gbRecord}(x, join = FALSE, key = TRUE, include = "none",
  exclude = "", ...)

\S4method{ranges}{gbRecordList}(x, join = FALSE, key = TRUE,
  include = "none", exclude = "", ...)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}},
\code{\linkS4class{gbRecord}}, or \code{\linkS4class{gbRecordList}} object.}

\item{join}{Join compound genomic locations into a single range.}

\item{key}{Include feature keys with ranges.}

\item{include}{Include qualifiers as metadata columns. Can be "none",
"all", or a character vector of qualifier tags.}

\item{exclude}{Exclude specific qualifiers.}

\item{...}{Further arguments passed to methods.}
}
\value{
A \code{\linkS4class{GRanges}} or \code{\linkS4class{GRangesList}} object.
}
\description{
Extract features as \code{"\linkS4class{GRanges}"} objects.
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))

## default "GRanges" object.
ranges(x)

## subset CDSs and include "product", "note", "protein_id" as metadata.
ranges(x["CDS"], include = c("product", "note", "protein_id"))

## subset CDSs and exclude "translation"
ranges(x["CDS"], include = "all", exclude = "translation")
}
\seealso{
\code{\link{start}}, \code{\link{end}}, \code{\link{span}}, \code{\link{strand}},
  \code{\link{location}}, \code{\link{key}}, \code{\link{qualif}}
}
