% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-error.R
\name{compose_error_v1.3.0}
\alias{compose_error_v1.3.0}
\alias{compose_error}
\title{Compose BioCompute Object - Error Domain (v1.3.0)}
\usage{
compose_error_v1.3.0(empirical = NULL, algorithmic = NULL)

compose_error(empirical = NULL, algorithmic = NULL)
}
\arguments{
\item{empirical}{Data frame. Variables include \code{key} and \code{value}.
Each row is one item in the empirical error subdomain.}

\item{algorithmic}{Data frame. Variables include \code{key} and \code{value}.
Each row is one item in the algorithmic subdomain.}
}
\value{
A list of class \code{bco.domain}
}
\description{
The error domain can be used to determine what range of input
returns outputs that are within the tolerance level defined
in this subdomain and therefore can be used to optimize algorithm
(\href{https://github.com/biocompute-objects/BCO_Specification/blob/1.3.0/error-domain.md}{domain definition}).
}
\examples{
empirical <- data.frame(
  "key" = c("false_negative_alignment_hits", "false_discovery"),
  "value" = c("<0.0010", "<0.05"),
  stringsAsFactors = FALSE
)

algorithmic <- data.frame(
  "key" = c("false_positive_mutation_calls", "false_discovery"),
  "value" = c("<0.00005", "0.005"),
  stringsAsFactors = FALSE
)

compose_error(empirical, algorithmic) \%>\% convert_json()
}
