% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ppi.R
\name{plot.ppi}
\alias{plot.ppi}
\title{Plot a plan position indicator (\code{ppi})}
\usage{
\method{plot}{ppi}(
  x,
  param,
  xlim,
  ylim,
  zlim = c(-20, 20),
  ratio = 1,
  na.value = "transparent",
  ...
)
}
\arguments{
\item{x}{An object of class \code{ppi}.}

\item{param}{The scan parameter to plot, see details below.}

\item{xlim}{Range of x values to plot.}

\item{ylim}{Range of y values to plot.}

\item{zlim}{The range of parameter values to plot.}

\item{ratio}{Aspect ratio between x and y scale.}

\item{na.value}{\link[ggplot2]{ggplot} argument setting the plot color of NA values}

\item{...}{Arguments passed to low level \link[ggplot2]{ggplot} function.}
}
\description{
Plot a plan position indicator (PPI) generated with \code{project_to_ppi}
using \link[ggplot2]{ggplot}
}
\details{
Available scan parameters for plotting can by printed to screen
by \code{summary(x)}. Commonly available parameters are:
\describe{
\item{"\code{DBZH}", "\code{DBZ}"}{(Logged) reflectivity factor (dBZ)}
\item{"\code{TH}", "\code{T}"}{(Logged) uncorrected reflectivity factor (dBZ)}
\item{"\code{VRADH}", "\code{VRAD}"}{Radial velocity (m/s). Radial
velocities towards the radar are negative, while radial velocities away
from the radar are positive}
\item{"\code{RHOHV}"}{Correlation coefficient (unitless). Correlation
between vertically polarized and horizontally polarized reflectivity factor}
\item{"\code{PHIDP}"}{Differential phase (degrees)}
\item{"\code{ZDR}"}{(Logged) differential reflectivity (dB)}
}
The scan parameters are named according to the OPERA data information
model (ODIM), see Table 16 in the
\href{https://github.com/adokter/vol2bird/blob/master/doc/OPERA2014_O4_ODIM_H5-v2.2.pdf}{ODIM specification}.
}
\examples{
# load an example scan:
data(example_scan)

# print to screen the available scan parameters:
summary(example_scan)

# make ppi for the scan
ppi <- project_as_ppi(example_scan)

# plot the default scan parameter, which is reflectivity "DBZH":
plot(ppi)

# plot the radial velocity parameter:
plot(ppi, param = "VRADH")

# change the range of reflectivities to plot, from -10 to 10 dBZ:
plot(ppi, param = "DBZH", zlim = c(-10, 10))

# change the scale name and colour scheme, using viridis colors:
plot(ppi, param = "DBZH", zlim = c(-10, 10)) + viridis::scale_fill_viridis(name = "dBZ")
}
