% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad-deprecated.R
\name{bioRad-deprecated}
\alias{bioRad-deprecated}
\alias{basemap}
\alias{beamheight}
\alias{beamwidth}
\alias{bind}
\alias{checkDocker}
\alias{composite}
\alias{day}
\alias{dbz2eta}
\alias{download_vp}
\alias{elangle}
\alias{eta2dbz}
\alias{fetch}
\alias{getscan}
\alias{h5ODIMobject}
\alias{is.vplist}
\alias{mt}
\alias{mtr}
\alias{cmt}
\alias{night}
\alias{ppi}
\alias{read.pvol}
\alias{readvp}
\alias{readvp.list}
\alias{readvp.table}
\alias{regularize}
\alias{retrieve_vp_paths}
\alias{rsl2odim}
\alias{sd_vvp}
\alias{suntime}
\alias{updateDocker}
\alias{vintegrate}
\alias{vol2bird}
\alias{vpts}
\alias{VP-deprecated}
\alias{VPTS-deprecated}
\alias{SCAN-deprecated}
\title{Deprecated functions and data in package \pkg{bioRad}}
\usage{
basemap(...)

beamheight(range, elev, k = 4/3, lat = 35, re = 6378, rp = 6357)

beamwidth(range, angle = 1)

bind(x, ...)

checkDocker(...)

composite(x, param = "DBZH", cells.dim = c(100, 100))

day(x, ..., elev = -0.268)

dbz2eta(dbz, wavelength, Km = 0.93)

download_vp(start_date, end_date, country, radar, localpath = ".")

elangle(...)

eta2dbz(eta, wavelength, Km = 0.93)

fetch(...)

getscan(x, angle)

h5ODIMobject(filename)

is.vplist(x)

mt(x, alt.min = 0, alt.max = Inf, alpha = NA, interval.max = Inf)

mtr(x, alt.min = 0, alt.max = Inf, alpha = NA)

cmt(x, alt.min = 0, alt.max = Inf, alpha = NA, interval.max = Inf)

night(x, ..., elev = -0.268)

ppi(
  x,
  cellsize = 500,
  range.max = 50000,
  project = FALSE,
  latlim = NULL,
  lonlim = NULL
)

read.pvol(
  filename,
  param = c("DBZH", "VRADH", "VRAD", "RHOHV", "ZDR", "PHIDP", "CELL"),
  sort = TRUE,
  lat,
  lon,
  height,
  elangle.min = 0,
  elangle.max = 90,
  verbose = TRUE,
  mount = dirname(filename)
)

readvp(...)

readvp.list(...)

readvp.table(...)

regularize(
  ts,
  interval = "auto",
  t.min = ts$daterange[1],
  t.max = ts$daterange[2],
  units = "mins",
  fill = FALSE,
  verbose = TRUE
)

retrieve_vp_paths(path, start_date, end_date, country = NULL, radar = NULL)

rsl2odim(vol.in, vol.out, verbose = FALSE, mount = dirname(vol.in))

sd_vvp(x)

suntime(..., rise = TRUE)

updateDocker(...)

vintegrate(...)

vol2bird(
  vol.in,
  vp.out = "",
  vol.out = "",
  autoconf = FALSE,
  verbose = FALSE,
  mount = dirname(vol.in),
  sd_vvp_threshold = 2,
  rcs = 11,
  dualpol = FALSE,
  rhohv = 0.95,
  elev.min = 0,
  elev.max = 90,
  azim.min = 0,
  azim.max = 360,
  range.min = 5000,
  range.max = 25000,
  nlayer = 20L,
  hlayer = 200,
  dealias = TRUE,
  nyquist.min = if (dealias) 5 else 25,
  dbz_quantity = "DBZH"
)

vpts(...)
}
\description{
The functions and data listed below are deprecated or renamed and will be
defunct in the near future. When possible, alternative functions with similar
functionality are mentioned.
}
\section{basemap}{

Use \code{\link{download_basemap}} instead.
}

\section{beamheight}{

Use \code{\link{beam_height}} instead.
}

\section{beamwidth}{

Use \code{\link{beam_width}} instead.
}

\section{bind}{

Use \code{\link{bind_into_vpts}} instead.
}

\section{checkDocker}{

Use \code{\link{check_docker}} instead.
}

\section{composite}{

Use \code{\link{composite_ppi}} instead.
}

\section{day}{

Use \code{\link{check_night}} instead.
}

\section{dbz2eta}{

Use \code{\link{dbz_to_eta}} instead.
}

\section{download_vp}{

Use \code{\link{download_vpfiles}} instead.
}

\section{elangle}{

Use \code{\link{get_elevation_angles}} instead.
}

\section{eta2dbz}{

Use \code{\link{eta_to_dbz}} instead.
}

\section{fetch}{

Use \code{\link{get_quantity}} instead.
}

\section{getscan}{

Use \code{\link{get_scan}} instead.
}

\section{h5ODIMobject}{

Use \code{\link{get_odim_object_type}} instead.
}

\section{is.vplist}{

The \code{vplist} object is deprecated. Use a regular list of \code{vp}
objects \code{c(vp, vp)} and check with {\code{sapply(x, is.vp)}}.
}

\section{mt}{

\code{mt} is deprecated as a separate function. Migration traffic is now
included in the output of \code{\link{integrate_profile}} as column
\code{mt}.

\strong{Deprecated description}

Total migration traffic, which is calculated by time-integration of
migration traffic rates. Migration traffic gives the number of individuals
that have passed per km perpendicular to the migratory direction at the
position of the radar for the full period of the time series within the
specified altitude band.

\strong{Deprecated examples}

\preformatted{
# get example time series of vertical profiles:
data(example_vpts)
example_vpts
# total migration traffic in full altitude band:
mt(example_vpts)
# total migration traffic in 0-1000 meter band:
mt(example_vpts, alt.min = 0, alt.max = 1000)
}
}

\section{mtr}{

\code{\link{mtr}} is deprecated as a separate function. Migration traffic
rate is now included in the output of \code{\link{integrate_profile}} as
column \code{mtr}.

\strong{Deprecated description}

Migration traffic rate (MTR) for an altitude layer, defined as the number of
targets crossing a 1 km line perpendicular to the migratory movement per
hour.

\strong{Deprecated details}

Migration traffic rate (MTR) for an altitude layer is a flux measure, defined
as the number of targets crossing a unit of transect per hour.

The transect direction is set by the angle \code{alpha}. When
\code{alpha=NA}, the transect runs perpendicular to the measured migratory
direction. \code{mtr} then equals the number of crossing targets per km
transect per hour, for a transect kept perpendicular to the measured
migratory movement at all times and altitudes. In this case \code{mtr} is
always a positive quantity, defined as:

\deqn{mtr = \sum_i dens_i ff_i \Delta h}{mtr = \sum_i dens_i ff_i \Delta h}

with the sum running over all altitude layers between \code{alt.min} and
\code{alt.max}, \eqn{dens_i} the bird density, \eqn{ff_i} the ground speed at
altitude layer i, and \eqn{\Delta h} the altitude layer width.

If \code{alpha} is given a numeric value, the transect is taken perpendicular
to the direction \code{alpha}, and the number of crossing targets per hour
per km transect is calculated as:

\deqn{mtr = \sum_i dens_i ff_i \cos(dd_i-alpha) \Delta h}{mtr = \sum_i dens_i
ff_i \cos(dd_i-alpha) \Delta h} with \eqn{dd_i} the migratory direction at
altitude i.

Note that this equation evaluates to the previous equation when \code{alpha}
equals \eqn{dd_i}.

In this definition \code{mtr} is a traditional flux into a direction of
interest. Targets moving into the direction \code{alpha} contribute
positively to \code{mtr}, while targets moving in the opposite direction
contribute negatively to \code{mtr}. Therefore \code{mtr} can be both
positive or negative, depending on the definition of alpha.

\strong{Deprecated examples}

\preformatted{
# MTR for a single vertical profile:
mtr(example_vp)
# MTRs for a time series of vertical profiles:
data(example_vpts)
# print migration traffic rates:
mtr(example_vpts)
# to plot migration traffic rate data, use integrate_profile:
plot(integrate_profile(example_vpts), quantity = "mtr")
}
}

\section{cmt}{

\code{\link{cmt}} is deprecated as a separate function. Cumulative migration
traffic is now included in the output of \code{\link{integrate_profile}} as
column \code{mt}, which gives the cumulative migration
traffic from the start of the vertical profile time series.

\strong{Deprecated description}

Cumulative migration traffic is calculated as the cumulative sum of the
migration traffic within each time step of a time series. Cumulative
migration traffic gives the number of individuals that have passed per km
perpendicular to the migratory direction at the position of the radar as a
function of time from the start of time series within the specified altitude
band.

\strong{Deprecated examples}

\preformatted{
# get example time series of vertical profiles:
data(example_vpts)

# print cumulative migration traffic to console:
cmt(example_vpts)
}
}

\section{night}{

Use \code{\link{check_night}} instead.
}

\section{ppi}{

Use \code{\link{project_as_ppi}} instead.
}

\section{read.pvol}{

Use \code{\link{read_pvolfile}} instead.
}

\section{readvp}{

Use \code{\link{read_vpfiles}} instead.
}

\section{readvp.list}{

Use \code{\link{read_vpfiles}} instead.
}

\section{readvp.table}{

Use \code{\link{read_vpts}} instead.
}

\section{regularize}{

Use \code{\link{regularize_vpts}} instead.
}

\section{retrieve_vp_paths}{

Use \code{\link{select_vpfiles}} instead.
}

\section{rsl2odim}{

Use \code{\link{nexrad_to_odim}} instead.
}

\section{sd_vvp}{

Use \code{\link{sd_vvp_threshold}} instead.
}

\section{suntime}{

Use \code{\link{sunrise}} or \code{\link{sunset}} instead.
}

\section{updateDocker}{

Use \code{\link{update_docker}} instead.
}

\section{vintegrate}{

Use \code{\link{integrate_profile}} instead.
}

\section{vol2bird}{

Use \code{\link{calculate_vp}} instead.
}

\section{vpts}{

Use \code{\link{bind_into_vpts}} instead.
}

\section{\code{VP}}{

Use \code{\link{example_vp}} instead.
}

\section{\code{VPTS}}{

Use \code{\link{example_vpts}} instead.
}

\section{\code{SCAN}}{

Use \code{\link{example_scan}} instead.
}

\keyword{internal}
